//
//  GlyphsPaletteProtocol.h
//  PalettePlugin
//
//  Created by Georg Seifert on 4.7.07.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol GSWindowControllerProtocol;

/** \brief GlyphsPalette: The protocol defining the palette plugin interface
 The protocol defining the palette plugin interface.
 */
@protocol GlyphsPalette

/**
 The window controller managing the window the panel is in
 */
@property (nonatomic, weak) NSWindowController<GSWindowControllerProtocol> *windowController NS_SWIFT_UI_ACTOR;
/// The interface version.
@property (readonly, nonatomic) NSUInteger interfaceVersion NS_SWIFT_UI_ACTOR;
/// The title of the plugin.
@property (readonly, nonatomic) NSString *title NS_SWIFT_UI_ACTOR;
/// the view to display in the palette.
@property (readonly, strong, nonatomic) NSView *theView NS_SWIFT_UI_ACTOR;
/// the minimal height of the view.
@property (readonly, nonatomic) NSInteger minHeight NS_SWIFT_UI_ACTOR;
/// the maximal height of the view.
@property (readonly, nonatomic) NSInteger maxHeight NS_SWIFT_UI_ACTOR;
@optional

/** The current height of the palette

 Implement this when your palette is resizable
 */
@property (assign, nonatomic) NSUInteger currentHeight NS_SWIFT_UI_ACTOR;

@optional

//! do main initialization
- (void)loadPlugin;

/** The group ID defines the position of the tool in the sidebar.

  - Dimensions: 10
  - FitCurve: 20
  - Layers: 30
  - Transform: 40
  */
@property (readonly, nonatomic) NSUInteger sortID NS_SWIFT_UI_ACTOR;

@end
